/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: EplCnStack_Config.h $

    $GlobalRev: 11554 $
    $Version: V2.1.23.0 $
    $Packaged: 2010-10-26 12:02 $

   Targets:

   Description:

      Stack configuration for NMT and SDO task

  Functions:


   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           01.10.2007  SB        created
*******************************************************************************/

#ifndef EPLCNSTACK_CONFIG_H_INCLUDED
#define EPLCNSTACK_CONFIG_H_INCLUDED

#include "EplCnStack_OsTypes.h"
#include "EplCnStack_Osal.h"

/* Object Dictionary Definitions for access rights */
#define EPL_OD_READ_PRE_OPERATIONAL_1         0x0001
#define EPL_OD_READ_PRE_OPERATIONAL_2         0x0002
#define EPL_OD_READ_READY_TO_OPERATE          0x0004
#define EPL_OD_READ_OPERATIONAL               0x0008
#define EPL_OD_READ_STOPPED                   0x0010
#define EPL_OD_READ_BASIC_ETHERNET            0x0020
#define EPL_OD_READ_NOT_ACTIVE                0x0040
#define EPL_OD_READ_DURING_RESET              0x0080

#define EPL_OD_WRITE_PRE_OPERATIONAL_1        0x0100
#define EPL_OD_WRITE_PRE_OPERATIONAL_2        0x0200
#define EPL_OD_WRITE_READY_TO_OPERATE         0x0400
#define EPL_OD_WRITE_OPERATIONAL              0x0800
#define EPL_OD_WRITE_STOPPED                  0x1000
#define EPL_OD_WRITE_BASIC_ETHERNET           0x2000
#define EPL_OD_WRITE_NOT_ACTIVE               0x4000
#define EPL_OD_WRITE_DURING_RESET             0x8000

#define EPL_OD_READ_ALL                       0x00FF
#define EPL_OD_WRITE_ALL                      0xFF00

#define EPL_OD_ACCESS_ALL                     0xFFFF


#define EPL_OD_OBJECTCODE_VAR                 0x07
#define EPL_OD_OBJECTCODE_ARRAY               0x08
#define EPL_OD_OBJECTCODE_RECORD              0x09

/******************************************************************************
 * OS-dependent Initialization parameters defined by EplCnStack_Osal.h
 */
typedef struct EPLCN_TASK_INITIALIZE_PARAM_Ttag EPLCN_TASK_INITIALIZE_PARAM_T;

/******************************************************************************
 * OS-independent Stack initialization parameters
 */
typedef struct EPLCN_INITIALIZE_STACK_Ttag
{
  const struct EPLCN_TASK_INITIALIZE_PARAM_Ttag*    ptSdoTaskParameters;
  const struct EPLCN_TASK_INITIALIZE_PARAM_Ttag*    ptNmtTaskParameters;

  /* Basic Ethernet timeout in us */
  UINT32                                            ulBasicEthernetTimeout;

  /* EplCn configuration */
  UINT8                                             bSoCTriggerConfig;
  UINT32                                            ulSoCTriggerDelay;
  UINT32                                            ulSoCTriggerLength;
  EPLv2_CN_BOOLEAN                                  fEnableColLed;

  /* Initial Identity Data */
  UINT32                                            ulVendorId;
  UINT32                                            ulProductCode;
  UINT32                                            ulRevisionNumber;
  UINT32                                            ulSerialNumber;

  UINT8                                             bNodeAddress;

  UINT32                                            ulDeviceType;

  UINT32                                            ulFeatureFlags;

  /* Hardware Configuration */
  UINT32                                            ulSoCTimerNo;

  /* Initial Configuration */
  UINT32                                            ulCycleLen;
  UINT32                                            ulSoCJitterRange;
  UINT32                                            ulLossOfFrameTolerance;
  UINT32                                            ulDefaultGateway;

  UINT32                                            ulCollisionThreshold;
  UINT32                                            ulLossSoCThreshold;
  UINT32                                            ulLossSoAThreshold;
  UINT32                                            ulLossPReqThreshold;
  UINT32                                            ulSoCJitterThreshold;
  UINT32                                            ulCrcErrorThreshold;

  /* IP initial configuration */
  EPLv2_CN_BOOLEAN                                  fIpForwardingEnabled;
  /* Default TTL */
  UINT8                                             bTtl;
  /* Maximum IP datagram reassembly size */
  UINT16                                            usReasmMaxSize;

  /* Number of status entries configured */
  UINT32                                            ulNumStatusEntries;
} EPLCN_INITIALIZE_STACK_T;


#endif // EPLCNSTACK_CONFIG_H_INCLUDED
